
function AISMN_GoToSpotBandit::OnEnter(%this, %data)
{
   // try to go to the bandit target (if bandit cannot reach the
   // bandit target, remove the bandit from the bandit attack
   // and leave town)
   %object = GetThisObject(%data);
   if (SetPathForBuilding(%data, %object.banditTarget, 3) == false)
   {
      // remove the bandit from the bandit attack
      %manager = $DisasterManager;
      %disaster = %manager.getBanditAttack(%object);
      if (isObject(%disaster) == true)
      {
         %disaster.removeBandit(%object);
      }
      
      // remove the disaster alert if it has not yet been removed
      %message = slgGetUIString("id_bandit_attack_over");
      alertSvrRemoveObject($ALERT_BANDIT, %object.banditTarget, %message);
      
      // leave the map
      %data.performAction("leave");
      SetStateVariable(%obj,0,1);
      return;
   }

   %object.playThread(0, "run");
   return;
}

function AISMN_GoToSpotBandit::OnExit(%this, %data)
{
   GetThisObject(%data).playThread( 0, "root");
   SetSpeedScalar(%data, 1.0);
   %target = GetParameterTarget(%data);
   if(isObject(%target)) 
   {
      MsgSender.sendMsg($MSG_SLGOBJMOVE, $MRT_LOCAL, GetThisObject(%data), %target);
   }
}

function AISMN_GoToSpotBandit::Update(%this,%data)
{
   // if could not reach target, abort
   if (GetStateVariable(%data, 0) >= 1)
   {
      ReturnValue(%data, 2);
      return;
   }
   
   // if someone has started attacking the bandit
   if (%data.isUnderAttack() == true)
   {
      %data.attacker = %data.GetAttackerOf();
      ReturnValue(%data, 1);
      return;
   }
   
   // if the bandit's ally is under attack
   if (%data.allyIsUnderAttack() == true)
   {
      %ally = %data.getAllyUnderAttack();
      %data.attacker = %data.GetAttackerOf(%ally);
      ReturnValue(%data, 1);
      return;
   }

   // the bandit is done moving   
   if (IsFollowingPath(%data) == false)
   {
      // if the bandit has reached its destination, then it will
      // proceed to attack the buildings
      %object = GetThisObject(%data);
      %building = slgQueryInterface(%object.banditTarget, $CID_BUILDING);
      %pos = %building.getDoor();
      if (IsSameRegion(%object, getWord(%pos, 0), getWord(%pos, 1)) == true)
      {
         ReturnValue(%data, 0);
         return;
      }
      
      // remove the bandit from the bandit attack
      %manager = $DisasterManager;
      %disaster = %manager.getBanditAttack(%object);
      if (isObject(%disaster) == true)
      {
         %disaster.removeBandit(%object);
      }
      
      // remove the disaster alert if it has not yet been removed
      %message = slgGetUIString("id_bandit_attack_over");
      alertSvrRemoveObject($ALERT_BANDIT, %object.banditTarget, %message);
      
      // leave the map
      %data.performAction("leave");
      ReturnValue(%data, 2);
      return;
   }
   
   ReturnValue(%data, -1);
}
